import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(12, 3))

# Define colors for statuses
clear_color = 'green'
not_clear_color = 'red'

# Define positions and sizes
curb_width = 1.5
curb_height = 1
car_radius = 0.2
curb_positions = [(i * (curb_width + 0.5), 0) for i in range(7)]

# Define curbs and cars with their statuses
curbs = [
    {'id': 'curb_0', 'cars': ['car6', 'car7'], 'status': not_clear_color},
    {'id': 'curb_1', 'cars': ['car1', 'car8'], 'status': not_clear_color},
    {'id': 'curb_2', 'cars': ['car9', 'car4'], 'status': not_clear_color},
    {'id': 'curb_3', 'cars': ['car3'], 'status': clear_color},
    {'id': 'curb_4', 'cars': ['car0'], 'status': clear_color},
    {'id': 'curb_5', 'cars': ['car5'], 'status': clear_color},
    {'id': 'curb_6', 'cars': ['car2'], 'status': clear_color},
]

# Draw curbs and cars
for i, curb in enumerate(curbs):
    # Draw curb
    curb_x, curb_y = curb_positions[i]
    ax.add_patch(patches.Rectangle((curb_x, curb_y), curb_width, curb_height, edgecolor='black', facecolor='none'))
    ax.text(curb_x + curb_width / 2, curb_y + curb_height / 2, curb['id'], ha='center', va='center', fontsize=8)

    # Draw cars
    for j, car in enumerate(curb['cars']):
        car_x = curb_x + curb_width / 4 + j * curb_width / 2
        car_y = curb_y + curb_height / 2
        ax.add_patch(patches.Circle((car_x, car_y), car_radius, edgecolor='black', facecolor=curb['status']))
        ax.text(car_x, car_y, car, ha='center', va='center', fontsize=6, color='white')

# Create legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear'),
    patches.Patch(facecolor=not_clear_color, edgecolor='black', label='Not Clear')
]
ax.legend(handles=legend_elements, loc='upper right')

# Set limits and hide axes
ax.set_xlim(-0.5, 11)
ax.set_ylim(-1, 2)
ax.axis('off')

# Save the figure
plt.savefig('parking/one_shot/ini_diagram_code/attempts/attempt_1.png')
plt.show()
# VERIFICATION FAILED:
# Missing cars and curbs in the diagram.
